/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.vpdmgr;

import com.ibm.hwmca.base.vpdmgr.VpdConfigurationData;
import com.ibm.hwmca.base.vpdmgr.VpdUnitData;
import com.ibm.hwmca.fw.util.Trace;
import java.io.BufferedInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

class VpdcFileAccess {
    private static final String TRACE_MASKT = "XVPDFA T";
    private static final String TRACE_MASKF = "XVPDFA F";
    private static final String TRACE_MASKD = "XVPDFA D";
    private static final String VPDC_VERSION_01 = "V01";
    private static final String VPDC_VERSION_02 = "V02";
    private static final int CEC_RECORD_LENGTH = 75;
    private static final int VPDC_RECORD_LENGTH = 50;
    private static final int OLD_VPDC_RECORD_LENGTH = 37;
    private static final int VERSION_LENGTH = 4;
    private static final int RESERVED_LENGTH = 4;
    private static final int MACHINE_SERIAL_LENGTH = 13;
    private static final int MACHINE_TYPE_LENGTH = 5;
    private static final int MACHINE_MODEL_LENGTH = 4;
    private static final int CEC_SERIAL_LENGTH = 13;
    private static final int EXP_BOX_SERIAL_LENGTH = 13;
    private static final int CEC_LOCATION_LENGTH = 5;
    private static final int EXP_BOX_LOCATION_LENGTH = 5;
    private static final int RESERVED2_LENGTH = 9;
    private static final int UNIT_TYPE_LENGTH = 4;
    private static final int BOARD_ID_LENGTH = 2;
    private static final int OLD_BOARD_ID_LENGTH = 1;
    private static final int LOCATION_LENGTH = 5;
    private static final int UPC_SERIAL_LENGTH = 13;
    private static final int UNIT_SERIAL_LENGTH = 13;
    private static final int POWER_ON_LENGTH = 1;
    private static final int RESERVED3_LENGTH = 12;
    private static final int OFFSET_VERSION = 0;
    private static final int OFFSET_RESERVED = 4;
    private static final int OFFSET_MACHINE_SERIAL = 8;
    private static final int OFFSET_MACHINE_TYPE = 21;
    private static final int OFFSET_MACHINE_MODEL = 26;
    private static final int OFFSET_CEC_SERIAL = 30;
    private static final int OFFSET_EXP_BOX_SERIAL = 43;
    private static final int OFFSET_CEC_LOCATION = 56;
    private static final int OFFSET_EXP_BOX_LOCATION = 61;
    private static final int OFFSET_RESERVED2 = 66;
    private static final int OFFSET_UNIT_TYPE = 77;
    private static final int OFFSET_BOARD_ID = 81;
    private static final int OFFSET_LOCATION = 83;
    private static final int OFFSET_UPC_SERIAL = 88;
    private static final int OFFSET_UNIT_SERIAL = 101;
    private static final int OFFSET_POWER_ON = 114;
    private static final int OFFSET_RESERVED3 = 115;
    private static final int OFFSET_OLD_UNIT_TYPE = 77;
    private static final int OFFSET_OLD_BOARD_ID = 81;
    private static final int OFFSET_OLD_LOCATION = 82;
    private static final int OFFSET_OLD_UPC_SERIAL = 87;
    private static final int OFFSET_OLD_UNIT_SERIAL = 100;
    private static final int OFFSET_OLD_POWER_ON = 113;

    VpdcFileAccess() {
    }

    static List readVpdc(File filename) throws IOException {
        Trace.trace(TRACE_MASKT, "-> VpdcFileAccess.readVpdc()");
        byte[] b = null;
        ArrayList<Object> VPDCRecords = new ArrayList<Object>();
        int recordLength = 0;
        boolean newVPDC = false;
        BufferedInputStream file = new BufferedInputStream(new FileInputStream(filename));
        b = new byte[file.available()];
        file.read(b);
        file.close();
        VpdConfigurationData cd = new VpdConfigurationData(new String(b, 0, 3).trim(), new String(b, 8, 12).trim(), new String(b, 21, 4).trim(), new String(b, 26, 3).trim(), new String(b, 30, 12).trim(), new String(b, 43, 12).trim(), new String(b, 56, 4).trim(), new String(b, 61, 4).trim());
        VPDCRecords.add(cd);
        String version = cd.getVersion();
        if (version.equals(VPDC_VERSION_01) || version.equals(VPDC_VERSION_02)) {
            Trace.trace(TRACE_MASKF, "This is a Freeway or later VPDC");
            newVPDC = true;
            recordLength = 50;
        } else {
            Trace.trace(TRACE_MASKF, "This is an old VPDC");
            newVPDC = false;
            recordLength = 37;
        }
        VpdUnitData d = null;
        int numberRecords = (b.length - 75 - 2) / recordLength;
        int currentRecord = 0;
        while (currentRecord < numberRecords) {
            d = newVPDC ? new VpdUnitData(new String(b, 77 + recordLength * currentRecord, 3).trim(), VpdcFileAccess.bytes2Int(b[81 + recordLength * currentRecord], b[82 + recordLength * currentRecord]), new String(b, 83 + recordLength * currentRecord, 4).trim(), new String(b, 88 + recordLength * currentRecord, 12).trim(), new String(b, 101 + recordLength * currentRecord, 12).trim(), new String(b, 114 + recordLength * currentRecord, 1).charAt(0) == 'Y') : new VpdUnitData(new String(b, 77 + recordLength * currentRecord, 3).trim(), new String(b, 81 + recordLength * currentRecord, 1), new String(b, 82 + recordLength * currentRecord, 4).trim(), new String(b, 87 + recordLength * currentRecord, 12).trim(), new String(b, 100 + recordLength * currentRecord, 12).trim(), new String(b, 113 + recordLength * currentRecord, 1).charAt(0) == 'Y');
            VPDCRecords.add(d);
            ++currentRecord;
        }
        Trace.trace(TRACE_MASKT, "<- VpdcFileAccess.readVpdc()");
        return VPDCRecords;
    }

    static void writeVpdc(File filename, List list) throws IOException {
        Trace.trace(TRACE_MASKT, "-> VpdcFileAccess.writeVpdc()");
        Trace.trace(TRACE_MASKT, "Writing to file " + filename.getPath());
        ArrayList l = (ArrayList)list;
        int numberRecords = l.size();
        boolean currentOffset = false;
        int recordLength = 0;
        boolean newVPDC = false;
        VpdConfigurationData cd = (VpdConfigurationData)l.get(0);
        String version = cd.getVersion();
        if (version.equals(VPDC_VERSION_01) || version.equals(VPDC_VERSION_02)) {
            Trace.trace(TRACE_MASKF, "This is a Freeway or later VPDC");
            newVPDC = true;
            recordLength = 50;
        } else {
            Trace.trace(TRACE_MASKF, "This is an old VPDC");
            newVPDC = false;
            recordLength = 37;
        }
        DataOutputStream file = new DataOutputStream(new FileOutputStream(filename));
        file.writeBytes(cd.getVersion());
        int i = 0;
        while (i < 4 - cd.getVersion().length()) {
            file.writeByte(0);
            ++i;
        }
        int i2 = 0;
        while (i2 < 4) {
            file.writeByte(0);
            ++i2;
        }
        file.writeBytes(cd.getMachineSerial());
        int i3 = 0;
        while (i3 < 13 - cd.getMachineSerial().length()) {
            file.writeByte(0);
            ++i3;
        }
        file.writeBytes(cd.getMachineType());
        int i4 = 0;
        while (i4 < 5 - cd.getMachineType().length()) {
            file.writeByte(0);
            ++i4;
        }
        file.writeBytes(cd.getMachineModel());
        int i5 = 0;
        while (i5 < 4 - cd.getMachineModel().length()) {
            file.writeByte(0);
            ++i5;
        }
        file.writeBytes(cd.getCecSerial());
        int i6 = 0;
        while (i6 < 13 - cd.getCecSerial().length()) {
            file.writeByte(0);
            ++i6;
        }
        file.writeBytes(cd.getExpBoxSerial());
        int i7 = 0;
        while (i7 < 13 - cd.getExpBoxSerial().length()) {
            file.writeByte(0);
            ++i7;
        }
        file.writeBytes(cd.getCecLocation());
        int i8 = 0;
        while (i8 < 5 - cd.getCecLocation().length()) {
            file.writeByte(0);
            ++i8;
        }
        file.writeBytes(cd.getExpBoxLocation());
        int i9 = 0;
        while (i9 < 5 - cd.getExpBoxLocation().length()) {
            file.writeByte(0);
            ++i9;
        }
        int i10 = 0;
        while (i10 < 9) {
            file.writeByte(0);
            ++i10;
        }
        file.writeByte(13);
        file.writeByte(10);
        ListIterator iter = l.listIterator(1);
        while (iter.hasNext()) {
            VpdUnitData d = (VpdUnitData)iter.next();
            file.writeBytes(d.getUnitType());
            int i11 = 0;
            while (i11 < 4 - d.getUnitType().length()) {
                file.writeByte(0);
                ++i11;
            }
            if (newVPDC) {
                file.write(VpdcFileAccess.int2Bytes(d.getBoardId()), 0, 2);
            } else {
                file.writeBytes(d.getOldBoardID());
            }
            file.writeBytes(d.getLocation());
            int i12 = 0;
            while (i12 < 5 - d.getLocation().length()) {
                file.writeByte(0);
                ++i12;
            }
            file.writeBytes(d.getUpcSerial());
            int i13 = 0;
            while (i13 < 13 - d.getUpcSerial().length()) {
                file.writeByte(0);
                ++i13;
            }
            file.writeBytes(d.getUnitSerial());
            int i14 = 0;
            while (i14 < 13 - d.getUnitSerial().length()) {
                file.writeByte(0);
                ++i14;
            }
            file.writeBytes(new Character(d.getPowerOn()).toString());
            if (!newVPDC) continue;
            int i15 = 0;
            while (i15 < 12) {
                file.writeByte(0);
                ++i15;
            }
        }
        file.close();
        Trace.trace(TRACE_MASKT, "<- VpdcFileAccess.writeVpdc()");
    }

    private static int bytes2Int(byte byte1, byte byte2) {
        int y = 0;
        int x = byte1 & 0xFF;
        y = byte2 & 0xFF;
        return y << 8 | x;
    }

    private static byte[] int2Bytes(int i) {
        byte[] b = new byte[]{(byte)i, (byte)(i / 256)};
        return b;
    }
}

